import numpy as np

from allennlp.predictors import Predictor

from .attacker import BlackBoxAttacker
from .pwws import WordNetCandidate
from config import Config


class RandomAttacker(BlackBoxAttacker):
    def __init__(self, cf: Config, predictor: Predictor):
        super(RandomAttacker, self).__init__(cf, predictor)

        self.synonym_candidate = WordNetCandidate(self.supported_postag)

    def get_victim_substitute_pair(self, text):
        H = []
        for i, (token, tag) in enumerate(zip(text['sentence'], text['tag'])):
            synonyms = self.synonym_candidate.candidate_set(token, tag)
            if len(synonyms) == 0:
                continue
            synonym = np.random.choice(synonyms, 1)[0]
            H.append([i, synonym])
        attack_num = min(self.attack_num(len(text['sentence'])), len(H))
        Hi = np.random.choice(range(len(H)), size=attack_num, replace=False)

        return [H[i] for i in Hi]
